export default class Card{

    #x;
    #y;
    #width;
    #height;
    #scaleX;
    #scaleY;

    constructor(id){
        this.#width = 32;           // Largeur de la carte
        this.#height = 48;          // Hauteur de la carte
        this.id = id;               // ID de la carte sur le spritesheet (0 -> 51)
        this.isFlipped = false;     // Etat de la carte (retournée ou non)
        this.isBig = false;         // Taille x2 si vrai
    }
    get x(){ return this.#x || 0; }
    set x(value){ if(Math.round(value) !== this.#x){ APP.isUpdated = true; this.#x = Math.round(value); } }
    get y(){ return this.#y || 0; }
    set y(value){ if(Math.round(value) !== this.#y){ APP.isUpdated = true; this.#y = Math.round(value); } }
    get imgX(){ //Position X sur le spritesheet
        if(this.isFlipped){ return this.width * (this.id % 13); }   //Face
        if(this.isBig){ return this.#width; }                        //Dos grande taille
        return 0;                                                   //Dos taille normale
    }               
    get imgY(){ //Position Y sur le spritesheet
        if(this.isFlipped){ return this.#height * Math.floor(this.id / 13); }    //Face
        return 192;                                                              //Dos
    }
    get width(){ 
        if(!this.isFlipped && this.isBig){ return this.#width*2; }
        return this.#width;
    }
    get height(){ 
        if(!this.isFlipped && this.isBig){ return this.#height*2; }
        return this.#height;
    }
    get scaleX(){ return this.#scaleX || 1; }
    set scaleX(value){ if(value !== this.#scaleX){ APP.isUpdated = true; this.#scaleX = value; } }
    get scaleY(){ return this.#scaleY || 1; }
    set scaleY(value){ if(value !== this.#scaleY){ APP.isUpdated = true; this.#scaleY = value; } }

    get number(){ return Math.floor(this.id%13); }
    get sign(){ return Math.floor(this.id/13); }
    get color(){ return this.sign%2; }

    draw(ctx) {
        const img = APP.images['cards'];
        if(!img) return;    // Si l'image de carte n'est pas chargée, on empêche le dessin
        ctx.save();
        ctx.translate(this.x, this.y);
        ctx.scale(this.scaleX, this.scaleY);
        ctx.drawImage(img, this.imgX, this.imgY, this.width, this.height, -(this.width/2), -(this.height/2), this.width, this.height);
        ctx.restore();
    }

}